#!bin/sh

ChrootPath="/home/SSH_JAIL"
BinPath="/bin"

# Import cmd (bin + dependencies) to environment
for cmd in "$@"
do
	# Get all the dependencies of the current command 
	list="$(ldd ${BinPath}/${cmd} | egrep -o '/lib.*\.[0-9]')"

  # Var for binaries
	SRC="${BinPath}/${cmd}"
	DEST="${ChrootPath}${BinPath}/${cmd}"
  
  # Import binary
  cp -rv "${SRC}" "${DEST}"

	for lib in ${list}
	do
	  # Var for libs
		SRC="${lib}"
		DEST="${ChrootPath}${lib}"	
		
		# Import libs (dependencies)
		mkdir -p `dirname ${DEST}`
		cp -v "${SRC}" "${DEST}"
	done
done

